<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%report}}`.
 */
class m250919_160111_create_report_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%report}}', [
            'id' => $this->primaryKey(),
            'title' => $this->string(255)->notNull(), // название отчета
            'content' => $this->text()->notNull(),    // сам текст отчета
            'created_at' => $this->integer()->notNull(), // timestamp
            'updated_at' => $this->integer()->null(),   // можно обновлять
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%report}}');
    }
}
