<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%user}}`.
 */
class m250923_000234_create_user_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%user}}', [
            'id' => $this->primaryKey(),
            'first_name' => $this->string(50)->notNull()->comment('Имя'),
            'last_name' => $this->string(50)->notNull()->comment('Фамилия'),
            'middle_name' => $this->string(50)->comment('Отчество'),
            'phone' => $this->string(20)->notNull()->unique()->comment('Номер телефона'),
            'email' => $this->string(100)->unique()->comment('Почта'),
            'password_hash' => $this->string(255)->notNull()->comment('Хеш пароля'),
            'auth_key' => $this->string(32)->notNull()->comment('Ключ аутентификации'),
            'organization' => $this->string(150)->comment('Организация'),
            'created_at' => $this->integer()->notNull()->comment('Дата создания'),
            'updated_at' => $this->integer()->notNull()->comment('Дата обновления'),
        ], $tableOptions);

        $this->createIndex('idx-user-phone', '{{%user}}', 'phone');
        $this->createIndex('idx-user-email', '{{%user}}', 'email');

        // ТЕСТОВЫЕ ПОЛЬЗОВАТЕЛИ
        $this->batchInsert('{{%user}}', [
            'first_name',
            'last_name',
            'middle_name',
            'phone',
            'email',
            'password_hash',
            'auth_key',
            'organization',
            'created_at',
            'updated_at'
        ], [
            [
                'Иван',
                'Петров',
                'Сергеевич',
                '+79991234567',
                'ivan.petrov@agro.ru',
                Yii::$app->security->generatePasswordHash('password123'),
                Yii::$app->security->generateRandomString(),
                'КФХ "Рассвет"',
                time(),
                time()
            ],
            [
                'Мария',
                'Сидорова',
                'Ивановна',
                '+79997654321',
                'sidorova@agro.ru',
                Yii::$app->security->generatePasswordHash('demo123'),
                Yii::$app->security->generateRandomString(),
                'СПК "Восход"',
                time(),
                time()
            ],
            [
                'Алексей',
                'Кузнецов',
                null,
                '+79995556677',
                null,
                Yii::$app->security->generatePasswordHash('agro2024'),
                Yii::$app->security->generateRandomString(),
                'ООО "Агротех"',
                time(),
                time()
            ],
            [
                'Елена',
                'Васильева',
                'Александровна',
                '+79994443322',
                'vasileva@mail.ru',
                Yii::$app->security->generatePasswordHash('elena123'),
                Yii::$app->security->generateRandomString(),
                null,
                time(),
                time()
            ],
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%user}}');
    }
}