<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "crop_rotation".
 *
 * @property int $id
 * @property string $district Район
 * @property string $rotation_name Название ротации
 * @property string $year_1 Культура года 1
 * @property string $year_2 Культура года 2
 * @property string $year_3 Культура года 3
 * @property string $year_4 Культура года 4
 * @property string|null $notes Примечание
 * @property int $created_at Дата создания
 * @property int $updated_at Дата обновления
 */
class CropRotation extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%crop_rotation}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['district', 'rotation_name', 'year_1', 'year_2', 'year_3', 'year_4'], 'required'],
            [['notes'], 'string'],
            [['created_at', 'updated_at'], 'integer'],
            [['district', 'rotation_name'], 'string', 'max' => 100],
            [['year_1', 'year_2', 'year_3', 'year_4'], 'string', 'max' => 150],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'district' => 'Район',
            'rotation_name' => 'Название ротации',
            'year_1' => 'Год 1',
            'year_2' => 'Год 2',
            'year_3' => 'Год 3',
            'year_4' => 'Год 4',
            'notes' => 'Примечание',
            'created_at' => 'Дата создания',
            'updated_at' => 'Дата обновления',
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'timestamp' => [
                'class' => \yii\behaviors\TimestampBehavior::className(),
                'createdAtAttribute' => 'created_at',
                'updatedAtAttribute' => 'updated_at',
            ],
        ];
    }

    /**
     * @return array
     */
    public function getCropsArray()
    {
        return [
            'year_1' => $this->year_1,
            'year_2' => $this->year_2,
            'year_3' => $this->year_3,
            'year_4' => $this->year_4,
        ];
    }

    /**
     * @param string $district
     * @return \yii\db\ActiveQuery
     */
    public static function findByDistrict($district)
    {
        return self::find()->where(['district' => $district]);
    }

    /**
     * @return array
     */
    public static function getDistrictsList()
    {
        return self::find()
            ->select('district')
            ->distinct()
            ->indexBy('district')
            ->column();
    }
}