<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;
use app\models\Field;

/** @var yii\web\View $this */
/** @var app\models\Field $model */

$this->title = 'Добавление нового поля';
?>

<div class="container-fluid">
    <div class="row">
        <main class="col-md-12">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2 text-success">
                    <i class="bi bi-plus-circle me-2"></i> Добавление нового поля
                </h1>
                <a href="<?= Url::to(['giga-chat/calc']) ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left me-1"></i> Назад к калькулятору
                </a>
            </div>

            <?php if (Yii::$app->session->hasFlash('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?= Yii::$app->session->getFlash('success') ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if (Yii::$app->session->hasFlash('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?= Yii::$app->session->getFlash('error') ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-body">
                    <?php $form = ActiveForm::begin([
                        'id' => 'field-form',
                        'enableAjaxValidation' => false,
                    ]); ?>

                    <div class="row">
                        <div class="col-md-6">
                            <?= $form->field($model, 'name')->textInput([
                                'placeholder' => 'Например: Поле №1 - Северное',
                                'required' => true
                            ]) ?>

                            <?= $form->field($model, 'district')->dropDownList(
                                Field::DISTRICTS,
                                [
                                    'prompt' => 'Выберите район',
                                    'required' => true
                                ]
                            ) ?>

                            <?= $form->field($model, 'desired_culture')->textInput([
                                'placeholder' => 'Например: Озимая пшеница',
                                'required' => true
                            ]) ?>

                            <?= $form->field($model, 'area')->textInput([
                                'type' => 'number',
                                'step' => '0.01',
                                'placeholder' => 'Например: 50.00',
                                'required' => true
                            ]) ?>

                            <?= $form->field($model, 'soil_type')->dropDownList(
                                Field::SOIL_TYPES,
                                [
                                    'prompt' => 'Выберите тип почвы',
                                    'required' => true
                                ]
                            ) ?>
                        </div>

                        <div class="col-md-6">
                            <?= $form->field($model, 'nitrogen_content')->textInput([
                                'type' => 'number',
                                'step' => '0.01',
                                'placeholder' => 'Например: 25.50'
                            ]) ?>

                            <?= $form->field($model, 'phosphorus_content')->textInput([
                                'type' => 'number',
                                'step' => '0.01',
                                'placeholder' => 'Например: 15.30'
                            ]) ?>

                            <?= $form->field($model, 'potassium_content')->textInput([
                                'type' => 'number',
                                'step' => '0.01',
                                'placeholder' => 'Например: 18.20'
                            ]) ?>

                            <?= $form->field($model, 'humus_content')->textInput([
                                'type' => 'number',
                                'step' => '0.01',
                                'placeholder' => 'Например: 4.50'
                            ]) ?>

                            <?= $form->field($model, 'ph_level')->textInput([
                                'type' => 'number',
                                'step' => '0.1',
                                'min' => 0,
                                'max' => 14,
                                'placeholder' => 'Например: 6.8'
                            ]) ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <?= $form->field($model, 'predecessor')->textInput([
                                'placeholder' => 'Например: Ячмень'
                            ]) ?>
                        </div>
                        <div class="col-md-6">
                            <?= $form->field($model, 'user_id')->hiddenInput(['value' => 1])->label(false) ?>
                        </div>
                    </div>

                    <?= $form->field($model, 'notes')->textarea([
                        'rows' => 3,
                        'placeholder' => 'Дополнительные сведения о поле...'
                    ]) ?>

                    <div class="form-group">
                        <?= Html::submitButton('Сохранить поле', [
                            'class' => 'btn btn-success',
                            'id' => 'save-btn'
                        ]) ?>
                        <?= Html::a('Отмена', ['giga-chat/calc'], [
                            'class' => 'btn btn-outline-secondary'
                        ]) ?>

                        <div id="loading" style="display: none; margin-left: 10px; color: #198754;">
                            <i class="bi bi-arrow-repeat spin"></i> Сохранение...
                        </div>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </main>
    </div>
</div>

<style>
    .spin {
        animation: spin 1s linear infinite;
    }
    @keyframes spin {
        from { transform: rotate(0deg); }
        to { transform: rotate(360deg); }
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.getElementById('field-form');
        const saveBtn = document.getElementById('save-btn');
        const loading = document.getElementById('loading');

        form.addEventListener('submit', function(e) {
            saveBtn.disabled = true;
            loading.style.display = 'inline-block';

        });
    });
</script>